/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.setting.settings;

import Krasnodar.rockstarnew.systems.setting.SettingsContainer;
import Krasnodar.rockstarnew.systems.setting.impl.AbstractSetting;
import Krasnodar.rockstarnew.utility.animation.base.Animation;
import Krasnodar.rockstarnew.utility.animation.base.Easing;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;

public class GridSetting
extends AbstractSetting {
    private float x;
    private float y;
    private final float minX;
    private final float maxX;
    private final float minY;
    private final float maxY;
    private final float defaultX;
    private final float defaultY;
    private boolean dragging = false;
    private final Animation hoverAnimation = new Animation(200L, Easing.CUBIC_OUT);
    private final Animation dragAnimation = new Animation(150L, Easing.CUBIC_OUT);

    public GridSetting(@NotNull SettingsContainer parent, String name, String description, float defaultX, float defaultY) {
        this(parent, name, description, defaultX, defaultY, -2.5f, 2.5f, -2.0f, 2.0f, () -> false);
    }

    public GridSetting(@NotNull SettingsContainer parent, String name, String description, float defaultX, float defaultY, float minX, float maxX, float minY, float maxY, @NotNull BooleanSupplier hideCondition) {
        super(parent, name, hideCondition);
        this.x = defaultX;
        this.y = defaultY;
        this.defaultX = defaultX;
        this.defaultY = defaultY;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    public void setPosition(float x, float y) {
        this.x = this.clamp(x, this.minX, this.maxX);
        this.y = this.clamp(y, this.minY, this.maxY);
    }

    public void reset() {
        this.setPosition(this.defaultX, this.defaultY);
    }

    private float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    @Override
    public JsonElement save() {
        JsonObject positionObject = new JsonObject();
        positionObject.addProperty("x", (Number)Float.valueOf(this.x));
        positionObject.addProperty("y", (Number)Float.valueOf(this.y));
        return positionObject;
    }

    @Override
    public void load(JsonElement element) {
        JsonObject positionObject;
        if (element.isJsonObject() && (positionObject = element.getAsJsonObject()).has("x") && positionObject.has("y")) {
            this.x = positionObject.get("x").getAsFloat();
            this.y = positionObject.get("y").getAsFloat();
        }
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }
}

